module.exports = function(sequelize, DataTypes) {
    return sequelize.define('Group', {
        id: { type: DataTypes.INTEGER, primaryKey: true , autoIncrement: true },
        leader_id: { type: DataTypes.INTEGER, allowNull: false },
        group_name: { type: DataTypes.STRING(50), allowNull: false },
        description: { type: DataTypes.STRING, allowNull: true },
        join_code: { type: DataTypes.STRING, allowNull: false },
        enabled: {type: DataTypes.BOOLEAN, allowNull: false, defaultValue: true}
    },
    {
        timestamps: false,
        underscored: true,
        freezeTableName: true,
        tableName: 'groups'
    });
};